// Tank Ravagers 3.20
// Based heavily on STARFERR.CPP - Windows Game Programming For Dummies
// Main Coder : benr@loirak.com, Loirak Enterprises
// Additional Programming 
//		BGCjr (bobbyc@netquick.net) (Menus/Fixed TankStop bug)
// Greetz - TheCooky, Evilhawk, Tangin

// Want to add something to Tank or use it to make your own game. GO FOR IT!
// Tank was put on the Web so people could make their own games, demos, and
// have fun programming in DirectX.

// If you add anything that would be cool to have added on the download page
// let us know : programming@loirak.com

// If you are having trouble with compiling make sure to read COMPILE.TXT that
// is included with the TANKSRC.ZIP

// INCLUDES ///////////////////////////////////////////////

#define WIN32_LEAN_AND_MEAN
#define INITGUID

#include <windows.h>   // include important windows stuff
#include <windowsx.h>
#include <mmsystem.h>
#include <objbase.h>
#include <iostream.h> // include important C/C++ stuff
#include <conio.h>
#include <stdlib.h>
#include <malloc.h>
#include <memory.h>
#include <string.h>
#include <stdarg.h>
#include <stdio.h>
#include <math.h>
#include <io.h>
#include <fcntl.h>

#include <ddraw.h>     // directX includes
#include "gpdumb1.h"   // sprite libraries
#include "tsound.h"    // sound routines WAV/MIDI

// DEFINES ////////////////////////////////////////////////

// defines for windows
#define WINDOW_CLASS_NAME "WINXCLASS"  // class name

#define WINDOW_WIDTH    64   // size of window
#define WINDOW_HEIGHT   48

// images size, I hope I don't have to use powers of two
// Bomb 26x9(8)   --objects.bmp : 0,200 - 25, 208
// Tank 80x21(20) --objects.bmp : left 100,150 - 179,170
//                               right   0,150 -  79,170
// GameOver 354x30--objects.bmp : 0,250 - 252, 279

// tank constants
#define MAX_TANK_X   400
#define MAX_BOMB_Y   431
#define MAX_BOMBS    6
#define BOMB_STATE_OFF   0   // this bomb is dead or off
#define BOMB_STATE_ON    1   // this one is alive and in flight

#define TANK_RIGHT   0
#define TANK_LEFT    1


// tanks constant y is 441, it can move(x) between 0 and 400
// bomb can move from y 0-431, with x between 2 and 374

// defines for player states
#define PLAYER_STATE_DEAD     0
#define PLAYER_STATE_DYING    1
#define PLAYER_STATE_ALIVE    2

// PROTOTYPES /////////////////////////////////////////////

// game console
int Game_Init(void *parms=NULL);
int Game_Shutdown(void *parms=NULL);
int Game_Main(void *parms=NULL);
int Game_Menu(void *parms=NULL); // returns 0 for success/ -1 for ESC pressed
// helper functions for game logic

void Init_Bombs(void);
void Draw_Bombs(void);
void Delete_Bombs(void);
void Move_Bombs(void);
void Draw_Stats(void);

// TYPES //////////////////////////////////////////////////

// GLOBALS ////////////////////////////////////////////////

HWND main_window_handle = NULL; // save the window handle
HINSTANCE main_instance = NULL; // save the instance
char buffer[80];                // used to print text

// tank GLOBALS
PALETTEENTRY gPalette[256]; // palette for main game

BOB screenintro; // the main background for the game
BOB menu; // red part for menu
BOB s1; // Highlight startgame
BOB s2; // highlight info
BOB s3; // highlight exitgame

BOB tank;                  // the player

BOB tankl;  // BOBs for each direction, I am lazy
BOB tankr;

BOB bombs[MAX_BOMBS];      // what player has to dodge

// player state variables
		 int player_state = PLAYER_STATE_ALIVE;
		 int player_score = 0;  // the score
		 int player_damage = 0; // damage of player
								// set to Zero initially so MENU will run
		 int player_going = 2; // not moving???
		 //int fr = 1;
		 int opg=0; // keeps track of which way the player is going
		 int gms;
// PROTOTYPES //////////////////////////////////////////////

// FUNCTIONS //////////////////////////////////////////////

LRESULT CALLBACK WindowProc(HWND hwnd, 
						    UINT msg, 
                            WPARAM wparam, 
                            LPARAM lparam)
{
// this is the main message handler of the system
PAINTSTRUCT	ps;		   // used in WM_PAINT
HDC			hdc;	   // handle to a device context

// what is the message
switch(msg)
	{	
	case WM_CREATE: 
        {
		// do initialization stuff here
		return(0);
		} break;

    case WM_PAINT:
         {
         // start painting
         hdc = BeginPaint(hwnd,&ps);

         // end painting
         EndPaint(hwnd,&ps);
         return(0);
        } break;

	case WM_DESTROY: 
		{
		// kill the application			
		PostQuitMessage(0);
		return(0);
		} break;

	default:break;

    } // end switch

// process any messages that we didn't take care of 
return (DefWindowProc(hwnd, msg, wparam, lparam));

} // end WinProc

// WINMAIN ////////////////////////////////////////////////

int WINAPI WinMain(	HINSTANCE hinstance,
					HINSTANCE hprevinstance,
					LPSTR lpcmdline,
					int ncmdshow)
{
// this is the winmain function

WNDCLASS winclass;	// this will hold the class we create
HWND	 hwnd;		// generic window handle
MSG		 msg;		// generic message
HDC      hdc;       // generic dc
PAINTSTRUCT ps;     // generic paintstruct

// first fill in the window class stucture
winclass.style			= CS_DBLCLKS | CS_OWNDC | 
                          CS_HREDRAW | CS_VREDRAW;
winclass.lpfnWndProc	= WindowProc;
winclass.cbClsExtra		= 0;
winclass.cbWndExtra		= 0;
winclass.hInstance		= hinstance;
winclass.hIcon			= LoadIcon(NULL, IDI_APPLICATION);
winclass.hCursor		= LoadCursor(NULL, IDC_ARROW);
winclass.hbrBackground	= (HBRUSH) GetStockObject(BLACK_BRUSH);
winclass.lpszMenuName	= NULL; 
winclass.lpszClassName	= WINDOW_CLASS_NAME;

// register the window class
if (!RegisterClass(&winclass))
	return(0);

// create the window, note the use of WS_POPUP
if (!(hwnd = CreateWindow(WINDOW_CLASS_NAME, // class
                                                  "Tank Ravagers",   // title
						  WS_POPUP | WS_VISIBLE,
					 	  0,0,	   // x,y
						  WINDOW_WIDTH,  // width
                          WINDOW_HEIGHT, // height
						  NULL,	   // handle to parent 
						  NULL,	   // handle to menu
						  hinstance,// instance
						  NULL)))	// creation parms
return(0);

// save the window handle and instance in a global
main_window_handle = hwnd;
main_instance      = hinstance;

// perform all game console specific initialization

Game_Init();

// enter main event loop
while(gms!=3)
	{
	if (PeekMessage(&msg,NULL,0,0,PM_REMOVE))
		{ 
		// test if this is a quit
        if (msg.message == WM_QUIT)
           break;

		// translate any accelerator keys
		TranslateMessage(&msg);

		// send the message to the window proc
		DispatchMessage(&msg);
		} // end if
    
    // main game processing goes here
    Game_Main();

	} // end while

// shutdown game and release all resources
Game_Shutdown();

// return to Windows like this
return(msg.wParam);

} // end WinMain

///////////////////////////////////////////////////////////

void Init_Bombs(void)
{
// this function initializes and loads all the bombs

	// load the bombs imagery 
	Load_Bitmap_File(&bitmap8bit, "OBJECTS.BMP");

	// now create and load each bomb
	for (int pulse=0; pulse<MAX_BOMBS; pulse++)
	{
		// create the bob to hold bombs (initial postion 0,300 size 26x8
		Create_BOB(&bombs[pulse],0,300,26,8,1,
			BOB_ATTR_VISIBLE | BOB_ATTR_SINGLE_FRAME,
			DDSCAPS_SYSTEMMEMORY);

		// load frame of Bomb from 0,200
		Load_Frame_BOB(&bombs[pulse],&bitmap8bit,0,0,200,BITMAP_EXTRACT_MODE_ABS);  

		// set state to off
		bombs[pulse].state = BOMB_STATE_OFF;
	} // end for bomb

	// All BOMBS are loaded into place, setup so don't start same place
	for (int index=0; index<MAX_BOMBS; index++) {
		bombs[pulse].state = BOMB_STATE_ON;
		Set_Vel_BOB(&bombs[index], 0, 2+rand()%2);
		Set_Pos_BOB(&bombs[index], rand()%374, rand()%430);
	}
	// unload data infile
	Unload_Bitmap_File(&bitmap8bit);

} // end Init_Bombs

///////////////////////////////////////////////////////////

void Delete_Bombs(void)
{
// this function simply deletes all memory and surfaces
// related to the bombs

for (int index=0; index<MAX_BOMBS; index++)
    Destroy_BOB(&bombs[index]);

} // end Delete_Bombs

///////////////////////////////////////////////////////////

void Move_Bombs(void)
{
// this function moves all the bombs pulses and checks for
// collision with the player (tank)

int x; // variable used in damage calculation

for (int index=0; index<MAX_BOMBS; index++)
    {
    // test if plasma pulse is in flight
    if (bombs[index].state == BOMB_STATE_ON)
        {
        // move the bomb downward
		  Move_BOB(&bombs[index]);
  
        // test for boundaries
        if (bombs[index].y > 431 )
            {

            // update score
            player_score = player_score + 1; // 1point per bomb
            
            //  if (tank.state==PLAYER_STATE_ALIVE) 

            if ((bombs[index].x+26 >= tank.x) && (bombs[index].x <= tank.x+79)) {
					// bomb collided with Tank
               x = player_damage - (10+rand()%20);
               if ( x < 0 ) player_damage = 0;
               else player_damage = x;
            }

            // kill the bomb
            bombs[index].state = BOMB_STATE_OFF;

            // move to next bomb
            continue;
            } // end if

      } // end if
      // since bomb is not on put it back somewhere on the top
	 if (bombs[index].state == BOMB_STATE_OFF)
        {

          Set_Vel_BOB(&bombs[index], 0, 2+rand()%2);
    
          // set position
          Set_Pos_BOB(&bombs[index], rand()%374, 0);
    
          // turn bomb on
          bombs[index].state = BOMB_STATE_ON;
          
        } // end if


    } // end for loop index

	if (player_damage <= 0) PlayWav("explode.wav");

} // end Move_Bombs

///////////////////////////////////////////////////////////

void Draw_Bombs(void)
{
	// this function draws all the bombs

	for (int index=0; index<MAX_BOMBS; index++)
	{
		// test if bomb is in flight
		if (bombs[index].state == BOMB_STATE_ON)
		{
			// draw the pulse
			Draw_BOB(&bombs[index],lpddsback);
		} // end if
	} // end for index
} // end Draw_Bombs

///////////////////////////////////////////////////////////

void Draw_Stats(void)
{
	// this function draws all the information at the right of the screen

	char score[16]; // hold score

	// build up scrore string
	sprintf(score,"0000000%d",player_score);

	// build up final string
	sprintf(buffer,"SCORE %s",&score[strlen(score)-8]);
	Draw_Text_GDI(buffer,490,106,251,lpddsback);
	// draw damage
	sprintf(buffer,"ARMOR %d%%",player_damage);
	Draw_Text_GDI(buffer,490,126,251,lpddsback);
	//Draw_Text_GDI(buffer,490,126,RGB(0,0,255),lpddsback);
} // end Draw_Stats

///////////////////////////////////////////////////////////

void Do_Intro(void)
{
	BOB introscreen; // screen for intro
	// draw the initial screen swirl thing
	DD_Fill_Surface(lpddsprimary, 0);
	Draw_Text_GDI("-=Press Enter=-",270,330,125,lpddsprimary);
	Load_Bitmap_File(&bitmap8bit, "TANK.BMP");
	Set_Palette(bitmap8bit.palette);
	Create_BOB(&introscreen,0,0,640,480,1,
		BOB_ATTR_VISIBLE | BOB_ATTR_SINGLE_FRAME,
		DDSCAPS_SYSTEMMEMORY);
	Load_Frame_BOB(&introscreen,&bitmap8bit,0,0,0,BITMAP_EXTRACT_MODE_ABS);  
	Set_Pos_BOB(&introscreen,0,0);
	Unload_Bitmap_File(&bitmap8bit);
	Draw_BOB(&introscreen,lpddsprimary);
	PlayWav("plane.wav");

	//Sleep(1500);
	while (!KEY_DOWN(VK_ESCAPE) && // wait for them to press a key
		!KEY_DOWN(VK_RETURN) &&
		!KEY_DOWN(VK_SPACE));
	
	Destroy_BOB(&introscreen);
	DD_Fill_Surface(lpddsprimary, 0); // screen clear

	Sleep(100); // kludge helps with ASync Key problems
} // end Do_Intro


// WINX GAME PROGRAMMING CONSOLE FUNCTIONS ////////////////

int Game_Init(void *parms)
{
// this function is where you do all the initialization
// for your game

	// initialize directdraw
	DD_Init(SCREEN_WIDTH, SCREEN_HEIGHT, SCREEN_BPP);

	// load all the objects
	Load_Bitmap_File(&bitmap8bit, "OBJECTS.BMP");
	// set the palette to background image palette
	Set_Palette(bitmap8bit.palette);
	Save_Palette(gPalette); // keep this palette around in a global

	// now create the tank
	Create_BOB(&tank,150,441,80,20,1, BOB_ATTR_VISIBLE | BOB_ATTR_SINGLE_FRAME, DDSCAPS_SYSTEMMEMORY);
	// load tank frames           frame, x, y
	Load_Frame_BOB(&tank,&bitmap8bit,0,0,150,BITMAP_EXTRACT_MODE_ABS);
	// set position
	Set_Pos_BOB(&tank,150,441);
	tank.state = PLAYER_STATE_ALIVE;
	// now create the right and left tank
	Create_BOB(&tankr,150,441,80,20,1, BOB_ATTR_VISIBLE | BOB_ATTR_SINGLE_FRAME, DDSCAPS_SYSTEMMEMORY);
	Load_Frame_BOB(&tankr,&bitmap8bit,0,0,150,BITMAP_EXTRACT_MODE_ABS);
	Set_Pos_BOB(&tankr,150,441);
	Create_BOB(&tankl,150,441,80,20,1, BOB_ATTR_VISIBLE | BOB_ATTR_SINGLE_FRAME, DDSCAPS_SYSTEMMEMORY);
	Load_Frame_BOB(&tankl,&bitmap8bit,0,100,150,BITMAP_EXTRACT_MODE_ABS);
	Set_Pos_BOB(&tankl,150,441);

	// now create the menu selections
	Create_BOB(&s2,244,220,94,29,1,  BOB_ATTR_VISIBLE | BOB_ATTR_SINGLE_FRAME,  DDSCAPS_SYSTEMMEMORY);
	Load_Frame_BOB(&s2,&bitmap8bit,0,6,6,BITMAP_EXTRACT_MODE_ABS);
	Set_Pos_BOB(&s2,244,220);
	Create_BOB(&s1,171,167,240,29,1, BOB_ATTR_VISIBLE | BOB_ATTR_SINGLE_FRAME,  DDSCAPS_SYSTEMMEMORY);
	Load_Frame_BOB(&s1,&bitmap8bit,0,0,39,BITMAP_EXTRACT_MODE_ABS);
	Set_Pos_BOB(&s1,171,167);
	Create_BOB(&s3,192,284,200,29,1, BOB_ATTR_VISIBLE | BOB_ATTR_SINGLE_FRAME, DDSCAPS_SYSTEMMEMORY);
	Load_Frame_BOB(&s3,&bitmap8bit,0,1,74,BITMAP_EXTRACT_MODE_ABS);
	Set_Pos_BOB(&s3,192,284);

	// load the background for the Menu part it is now in Objects.bmp
	// 342,5 -> 630,231
	//               InitPos, W,  H
	Create_BOB(&menu,144,128,289,227,1, BOB_ATTR_VISIBLE | BOB_ATTR_SINGLE_FRAME, DDSCAPS_SYSTEMMEMORY);
	Load_Frame_BOB(&menu,&bitmap8bit,0,342,5,BITMAP_EXTRACT_MODE_ABS);
	Set_Pos_BOB(&menu,144,128);

	// unload data infile
	Unload_Bitmap_File(&bitmap8bit);

	// load the normal background
	Load_Bitmap_File(&bitmap8bit, "STAR.BMP");
	Create_BOB(&screenintro,0,0,640,480,1, BOB_ATTR_VISIBLE | BOB_ATTR_SINGLE_FRAME, DDSCAPS_SYSTEMMEMORY);
	Load_Frame_BOB(&screenintro,&bitmap8bit,0,0,0,BITMAP_EXTRACT_MODE_ABS);
	Set_Pos_BOB(&screenintro,0,0);
	// Draw_BOB(&screenintro,lpddsprimary);
	Unload_Bitmap_File(&bitmap8bit);

	
	// initialize the bombs
	Init_Bombs();

	// set clipping rectangle to screen extents so objects dont
	// mess up at edges
	RECT screen_rect = {0,0,screen_width,screen_height};
	lpddclipper = DD_Attach_Clipper(lpddsback,1,&screen_rect);

	// seed random number generate
	srand(Start_Clock());

	// hide the mouse
	ShowCursor(FALSE);

	// do the introdcution
	Do_Intro();

	Set_Palette(gPalette); // change the pallette to the main palette

	// return success
	return(1);

} // end Game_Init

///////////////////////////////////////////////////////////

int Game_Shutdown(void *parms)
{
// this function is where you shutdown your game and
// release all resources that you allocated

// delete all the bombs
Delete_Bombs();
    
// delete the player and background
Destroy_BOB(&tank);
Destroy_BOB(&tankl);
Destroy_BOB(&tankr);
Destroy_BOB(&screenintro);
Destroy_BOB(&menu);
Destroy_BOB(&s1);
Destroy_BOB(&s2);
Destroy_BOB(&s3);
// shutdonw directdraw
DD_Shutdown();

// return success
return(1);
} // end Game_Shutdown

///////////////////////////////////////////////////////////

// returns 0 for success/ -1 for time to quit
int Game_Menu(void *parms)
{ 
	static runonce = 0;
	gms=1; // default menu selection to start game
	StopMidi();
	int done = 0;
	int index = 0; // used for resetting the bombs
	int retVal = 0;

	Sleep(100); // kludge wait helps to prevent ASync key problems (of which their are lots)

	while (!done) 
	{
		Start_Clock();

		// clear the drawing surface
		DD_Fill_Surface(lpddsback, 0);
		// draw the background
		Draw_BOB(&screenintro,lpddsback);

		Draw_BOB(&menu,lpddsback); // draw the red menu part

		// draw died message
		// dont draw this first time into the game
		if (runonce && player_damage <= 0)
			Draw_Text_GDI("You have DIED!",240,50,RGB(255, 0, 0),lpddsback);

		// HIGHLIGHT the correct portion of the Menu
		switch (gms){
		case 1:
			Draw_BOB(&s1,lpddsback);
			break;
		case 2:
			Draw_BOB(&s2,lpddsback);
			break;
		case 3:
			Draw_BOB(&s3,lpddsback);
			break;
		default: // should never get here
			Draw_BOB(&s1,lpddsback);
			break;
		} // end switch
		Draw_Stats(); 

		DD_Flip(); // render the screen
		Wait_Clock(50);

		if (KEY_DOWN(VK_ESCAPE) || KEY_DOWN(VK_F12)) // pressing ESC in MENU should quit program
		{
			gms=3;
			retVal = -1;
			done = 1; // quite while loop
		}
		if (KEY_DOWN(VK_UP))
		{
			gms--; // move up
			if (gms<=0) gms=3;
			Sleep(50); // kludge probs with ASync key
		}
		if (KEY_DOWN(VK_DOWN))
		{
			gms++;
			if (gms>=4) gms=1;
			Sleep(50); // kludge probs with ASync key
		}
		if (KEY_DOWN(VK_RETURN))
		{ 
			if (gms==1) // they want to start a game
			{
				player_state = PLAYER_STATE_ALIVE;
				player_score = 0;  // the score
				player_damage = 100; // damage of player
				player_going = 2; // not moving???
				opg=0; 
				for (index=0;index<MAX_BOMBS;index++)
					bombs[index].state = BOMB_STATE_OFF;
				done = 1; // quit while loop
				PlayMidi("bs-paran.mid");
				PlayWav("plane.wav");
			}
			if (gms==2)
			{
				Sleep(100); // kludge helps with ASync Key problems
				Do_Intro();
				Set_Palette(gPalette); // switch back to normal palette
				// dont set done becuase we want to return to the menu
			}
			if (gms==3)
			{
				done = 1;
				retVal = 01;
			}
		} // end RETURN processor
	} // end while loop
	runonce = 1;
	return retVal;
} // end MAIN MENU

///////////////////////////////////////////////////////////

int Game_Main(void *parms)
{
// this is the workhorse of your game it will be called
// continuously in real-time this is like main() in C
// all the calls for you game go here!

	// check of user is trying to exit
	if (KEY_DOWN(VK_ESCAPE) || KEY_DOWN(VK_F12) || player_damage <= 0) 
		if (Game_Menu()) // Game_Menu did not return 0, so post quit message
			PostMessage(main_window_handle, WM_DESTROY,0,0);

	// clear the drawing surface
	DD_Fill_Surface(lpddsback, 0);
	// draw the background
	Draw_BOB(&screenintro,lpddsback);

	// start the timing clock
	Start_Clock();

	// only process player if alive
	if (player_state == PLAYER_STATE_ALIVE)
	{
		// test if player is moving
		if (KEY_DOWN(VK_RIGHT))
		{
			player_going = TANK_RIGHT;
			opg=player_going;
		} // end if
		if (KEY_DOWN(VK_LEFT))
		{
			player_going = TANK_LEFT;
			opg=player_going;
		} // end if
		if (KEY_DOWN(VK_DOWN))
		{
			player_going = 2; // no take movement
		} // end if

		if (player_going == TANK_LEFT) // move player to left
			tank.x-=3;
		if (player_going == TANK_RIGHT) // move player to right
			tank.x+=3;

		// do bounds check (horizontal)
		if (tank.x < 1)
			tank.x = 1;
		else
			if (tank.x > MAX_TANK_X)
				tank.x = MAX_TANK_X;

	} // end if player alive
	else
		if (player_state = PLAYER_STATE_DYING)
		{
			// player is dying
		} // end if
		else
			if (player_state = PLAYER_STATE_DEAD)
				{
					// player is dead
				} // end if
	
	// move the bombs
	Move_Bombs();
	
	// draw the bombs
	Draw_Bombs();

	// draw the player if alive
	if (player_state == PLAYER_STATE_ALIVE)	
	{
		// this is the tricky part
		// Draw_BOB(&tank,lpddsback);
		if (player_going == TANK_RIGHT) 
		{
			tankr.x = tank.x; // x is the only thing that changes
			Draw_BOB(&tankr, lpddsback);
		} else
			if (player_going == TANK_LEFT) 
			{
				tankl.x = tank.x; // x is the only thing that changes
				Draw_BOB(&tankl, lpddsback);
			} else { // not going anywher so draw just tank
				tankl.x=tank.x;
				tankr.x=tank.x;
				if (opg==TANK_LEFT) Draw_BOB(&tankl,lpddsback);
				else {Draw_BOB(&tankr,lpddsback);
			}
		} // which one does this correspond to ??
	 } // end if draw player

	// draw the score and ships left
	Draw_Stats();

	// flip the surfaces
	DD_Flip();
	// sync to specific FPS rate (the lower this num, the faster the game)
	Wait_Clock(15);

	// return success
	return(1);

} // end Game_Main


