// File: tsound.cpp

// TSOUND is a generic sound library supporting MIDI/WAV/CD??
// Based off of Rockem Robots MIDI routines. Wav/CD support was added to those
// This generic library should work with any Win32 project. Just make sure you 
// have added winmm.lib to your object library modules. It does not use DirectSound
// and thus is more portable.

// Coder : benr@loirak.com (Loirak Enterprises)

// Includes....
#include "windows.h"
#include "tsound.h"
#include "stdio.h"

// Externals....
extern HWND	main_window_handle; // was g_hWnd

#define g_hWnd	main_window_handle 


//------------------------------------------------------------------
// Wav Functions
//------------------------------------------------------------------

BOOL PlayWav(char *sFileName)
{
	// I use this instead of MCI controls since you dont have to interrupt WAV playing
	PlaySound(sFileName, NULL, SND_ASYNC | SND_FILENAME);
	// The arguments are: (1) the name of the file; (2) NULL for the handle of the executable 
	// containing the resource because were not using a compiled resource; and (3) flags to 
	// ensure that the function returns as soon as possible, rather than waiting for the 
	// sound to finish, and that the first argument is interpreted as a file name.

	// If you wanted to use MCI possibly to add support for stop/pause/etc.
	// Here is some sample code

	/*
	mciSendString("open sound.wav alias sound", lpszReturnString, 
		lstrlen(lpszReturnString), NULL);
	mciSendString("play sound notify", lpszReturnString,
		lstrlen(lpszReturnString), NULL);
	mciSendString("record sound from 0 notify", lpszReturnString,
		lstrlen(lpszReturnString), NULL); */

    return TRUE;
}

//------------------------------------------------------------------
// Midi Functions
//------------------------------------------------------------------

BOOL PlayMidi(char *sFileName)
{
    char buf[256];

    sprintf(buf, "open %s type sequencer alias MUSIC", sFileName);
    
    if (mciSendString("close all", NULL, 0, NULL) != 0)
    {
	return(FALSE);
    }

    if (mciSendString(buf, NULL, 0, NULL) != 0)
    {
	return(FALSE);
    }

    if (mciSendString("play MUSIC from 0", NULL, 0, g_hWnd) != 0)
    {
	return(FALSE);
    }
    
    // Yahoo!
    return TRUE;
}

BOOL PauseMidi()
{
    // Pause if we're not already paused...
    if (mciSendString("stop MUSIC", NULL, 0, NULL) != 0)
    {
	return(FALSE);
    }

    
    // Yahoo!
    return TRUE;
}

BOOL ResumeMidi()
{	
    // Resume midi
    if (mciSendString("play MUSIC notify", NULL, 0, g_hWnd) != 0)
    {
	return(FALSE);
    }

    // Yahoo!
    return TRUE;
}

BOOL StopMidi()
{
    if (mciSendString("close all", NULL, 0, NULL) != 0)
    {
	return(FALSE);
    }	

    // Yahoo!
    return TRUE;
}

BOOL ReplayMidi()
{
    // Replay midi
    if (mciSendString("play MUSIC from 0 notify", NULL, 0, g_hWnd) != 0)
    {
	return(FALSE);
    }

    // Yahoo!
    return TRUE;
}

//------------------------------------------------------------------
// CDAudio Functions
//------------------------------------------------------------------

BOOL PlayCD()
{
    if (mciSendString("open cdaudio", NULL, 0, NULL) != 0)
		return(FALSE);
    if (mciSendString("play cdaudio", NULL, 0, NULL) != 0)
		return(FALSE);
	return TRUE;
}

BOOL PlayCDTrack(int trackNo)
{
	// This function has not been tested, and prolly wont work!
	char sbuf[100];
	sprintf(sbuf, "play cdaudio from %d to %d", trackNo, trackNo+1);

	//                              Str  lenstr, NULL
    if (mciSendString("open cdaudio", NULL, 0, NULL) != 0)
		return(FALSE);
    if (mciSendString("set cdaudio time format tmsf", NULL, 0, NULL) != 0)
		return(FALSE);
    if (mciSendString(sbuf, NULL, 0, NULL) != 0)
		return(FALSE);

	return TRUE;
}

BOOL EjectCD()
{
    if (mciSendString("set cdaudio door open", NULL, 0, NULL) != 0)
		return(FALSE);
	return TRUE;
}

BOOL PauseCD()
{
    if (mciSendString("stop cdaudio", NULL, 0, NULL) != 0)
		return(FALSE);
	return TRUE;
}

BOOL ResumeCD()
{
    if (mciSendString("play cdaudio notify", NULL, 0, g_hWnd) != 0)
    {
	return(FALSE);
    }
	return TRUE;
}


BOOL StopCD()
{
	if (mciSendString("close cdaudio","",0,0) != 0)
		return(FALSE);
    // Yahoo!
    return TRUE;
}

BOOL PlayNextTrackCD()
{
	char sbuf[100];
	int trackNo, trackCount;
    if (mciSendString("set cdaudio time format tmsf", NULL, 0, NULL) != 0)
		return(FALSE);
    if (mciSendString("status cdaudio current track", sbuf, strlen(sbuf), NULL) != 0)
		return(FALSE);
	trackNo = atoi(sbuf);
	trackNo++;
    if (mciSendString("status cdaudio number of tracks", sbuf, strlen(sbuf), NULL) != 0)
		return(FALSE);
	trackCount = atoi(sbuf);
	if (trackNo<trackCount)
	{
		sprintf(sbuf, "play cdaudio from %d to %d", trackNo, trackCount);
		if (mciSendString(sbuf, "", 0, 0) != 0)
			return(FALSE);
	}
	else
	{ // seek to start and begin again
         if (mciSendString("seek cdaudio to 0", "", 0, 0) != 0)
			 return FALSE;
		 if (mciSendString("play cdaudio", "", 0, 0) != 0)
			 return FALSE;

	}
	return TRUE;
}

 
